<?php
/**
 * The template for displaying search results pages
 *
 */

get_header();

if ( have_posts() ) {
  ?>



      <div id="inner-page-header" class="row" style="background:url(<?php echo the_post_thumbnail_url('large'); ?>);">
          <div class="container">

              <h1>      <?php
    printf(
      /* translators: %s: Search term. */
      esc_html__( 'Results for "%s"', 'twentytwentyone' ),
      '<span class="page-description search-term">' . esc_html( get_search_query() ) . '</span>'
    );
    ?></h1> <!-- Page Title -->

          </div>
      </div>



        <div class="row">
            <div class="container">
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">


  <div class="search-result-count default-max-width">
    <?php
    printf(
      esc_html(
        /* translators: %d: The number of search results. */
        _n(
          'We found %d result for your search.',
          'We found %d results for your search.',
          (int) $wp_query->found_posts,
          'twentytwentyone'
        )
      ),
      (int) $wp_query->found_posts
    );
    ?>
  </div><!-- .search-result-count -->


 <?php //get_template_part('filter','products'); ?>

  
  <?php
  // Start the Loop.
  while ( have_posts() ) {
    the_post();

    /*
     * Include the Post-Format-specific template for the content.
     * If you want to override this in a child theme, then include a file
     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
     */
    ?>




 <?php $image_url = get_the_post_thumbnail_url(); ?>

                        <div class="search-result row">
                            <div class="col-xs-12 col-sm-4 col-md-3 col-lg-3 col">
                                <a href="<?php the_permalink(); ?>"><img src="<?php echo $image_url; ?>"></a>


                            </div>
                            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-9 col">
                                <h3><span class="search-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span></h3>
                           

                                <?php  the_excerpt(); ?>


                                <a class="btn btn-primary btn-sm" href="<?php the_permalink(); ?>">View Details</a>
                            </div>
                        </div>




    <?php

   
    //get_template_part( 'template-parts/content/content-excerpt', get_post_format() );
  } // End the loop.

  // Previous/next page navigation.
  //twenty_twenty_one_the_posts_navigation();

  // If no content, include the "No posts found" template.
} else {
  echo 'No results for your search.';
  //get_template_part( 'template-parts/content/content-none' );
}


?>
                </div>
            </div>
        </div>


<?php

get_footer();
